# 대규모 트래픽 (1)

Created: July 28, 2023 10:05 AM
Tags: 4week

<aside>
❓ 대규모 트래픽으로 인한 서버 과부하를 어떻게 해결해야 하는지에 대해서 발표

</aside>

[https://www.notion.so/e73670a2be454a5c83708e0eb7398e45?pvs=4#0de3e8952c024fef8fdf44c2aabee194](https://www.notion.so/e73670a2be454a5c83708e0eb7398e45?pvs=21)

### 서버 과부화란?

- 간단히 말해서 응답없음이 뜨는 상황
- 그럼 보통 언제 일어나느냐? → 자원의 한계점에 도달했을 때!!!!
ex) 보통 서버의 CPU 사용량이 80-90%에
도달하거나 메모리가 부족해 계속해서 스와핑이 발생하면 과부화 상태

→ 어떻게 해결하느냐? → 모니터링을 통한 자원(CPU, 메모리, 대역폭)의 적절한 할당!!

---

### 모니터링 방법

- **AWS 오토스케일링**
    - 자원들을 자동적으로 용량을 증가시킨다
    - cloud watch가 계속 모니터링 하며 서버 대수를 늘려주는 방법
- **netdata 모니터링**
    - AWS를 사용안할 때 사용하는 무료 모니터링 서비스
    - memory에서 threshold값이 넘어가면 slcak에서 알림이 오고 자원을 할당하는 방식
    
    [https://github.com/netdata/netdata](https://github.com/netdata/netdata)
    

<aside>
💡 모니터링은 왜 하는가?

- 어떤 페이지에 어떤 트래픽이 얼마나 발생했는지 확인이 가능
- 어떤 네트워크에서 병목현상이 일어났는지 등 상황을 모니터링에서는 알려줌
- 즉 분석과 분산을 할 수 있는 토대가 됨

[Cloudflare Status](https://www.cloudflarestatus.com/)

</aside>

### 다른 방법들은 뭐가 있나?

- **로드밸런서**
    - AWS 오토스케일링이 빠르긴 하지만 구성을 하는데 시간이 많이 걸림 → cloud watch로 모니터링하기 이전에 트래픽을 분산시켜줘야 함
    - 한 서버에 장애가 발생하면 다른 서버로 리디렉션하여 시스템 중단 방지도 가능

![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled.png)

- **블랙스완 프로토콜**
    - 예측할 수 없는 사고 → 사후에 원인을 파악할 수는 있지만 사전에 예측은 불가능
    - 대비를 하긴 해야함 → 블랙스완이 일어났을 때 어떻게 할 지 수칙을 정함
    
    <aside>
    💡 왜 이름이 블랙스완 프로토콜인가?
    
    맨 처음 오스트레일리아에서 흑조가 발견될 때 사람들은 백조만 알았지 흑조가 있는 줄을 몰랐습니다. 일단
    발견되고 나니 생물학계는 물론이고 전 유럽이 충격에 휩싸였죠. 그러나 과학적 연구를 통해 왜 흑조가
    존재하는지 명확하게 알게 되었습니다.
    
    </aside>
    
    - 구글에서 사용 하는 수칙
    1. 영향을 받은 시스템과 각 시스템의 상대적 위험 수준을 확인
        - 체계적으로 데이터를 수집하고 원인에 대한 가설을 수립한 후 이를 테스팅
    2. 잠재적으로 영향을 받을 수 있는 내부의 모든 팀에 연락
    3. 최대한 빨리 취약점에 영향을 받는 모든 시스템을 업데이트
    4. 복원계획을 포함한 우리의 대응 과정을 파트너와 고객 등 외부에 전달

- **서킷 브래이커**
    - 연쇄적으로 생기는 에러를 방지하는 기법
    - 스레드의 차단
    
    ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%201.png)
    
    - 계단식 실패 발생
    
    ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%202.png)
    
    그냥 기다리면 안되나? → 기다리는 것은 좋은 UX가 아니다!
    
    - 동작 과정
    
    ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%203.png)
    
    - closed[정상] : 네트워크 요청의 실패율이 임계치보다 낮음
    - open[에러] : 임계치이상의 상태로 요청을 서비스로 전송하지 않고 바로
    오류를 반환하는데 이를 fail fast라고 함
    - half_open[확인중] : open 상태에서 일정 timeout으로 설정된 시간이 지나면 장애가 해결되었는지 확인하기 위해 half_open 상태로 전환됨. 여기서 요청을 전송하여 응답을 확인. 장애가 풀리는지를 확인해서 성공하면 closed, 실패하면 다시 open으로 변경
    
    ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%204.png)
    
    - 연속적인 에러를 발생을 막아주기 때문에 일부 서비스가 종료되더라도 다른 서비스들은 이상 없이 동작하게 만들 수 있다는 장점
    
    [https://github.com/Netflix/Hystrix](https://github.com/Netflix/Hystrix)
    
    [https://github.com/resilience4j/resilience4j](https://github.com/resilience4j/resilience4j)
    

- **컨텐츠 관리**
    - 불필요한 컨텐츠 제거
        - 이름만 필요한데 모든 정보를 불러 옴
        - ex) 이전 인프런에서 500개의 강의를 무료로 제공했던 이벤트가 있었는데 이때 오류가 났음 → 페이지에서 500개의 강의의 이름만 불러와서 보여주면 되는데 모든 정보를 다 불러와(selcet *) 용량을 초과해서 일어났던 일 → sql문 수정을 통해서 해결했다고 함 → 자세히 보고싶음면 → [https://tech.inflab.com/202201-event-postmortem/](https://tech.inflab.com/202201-event-postmortem/)
    - CDN을 통한 컨텐츠 제공
        - 변하지 않는 정보(Image, 고정된 JS/CSS/HTML 같은 정적 자원들을 메인서버에서 제공하지 않고 분산된 서버(CDN)을 통해서 제공함으로 비용을 줄임
    
    ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%205.png)
    
    - 컨텐츠 캐싱
        - 네트워크 트래픽을 해결하는 가장 좋은 방법이 뭐냐? → 해당 트래픽이 발생하지 않도록 하는 것(너무 당연한 말 아닌가,,,)
        - 브라우저 캐시(쿠키,로컬저장소, 세션저장소)를 통해서 해당 요청에 관한 항목을 캐시에서 응답을 읽어서 네트워크 요청에 관한 비용을 모두 제거하는 방식!
    - 컨텐츠 압축
        - txt기반이면 압축을 해서 보내는게 좋음(gzip, Brotli를 통해서 70%까지 압축 가능)
        - 압축했기 때문에 압축을 풀기위해 서버에서 자원을 사용하는 양까지 고려를 해야 한다고 함
    - 컨텐츠의 우하한 저하 → 경량화
        - 시스템 과도한 부하를 줄이기 위해 제공하는 컨텐츠 및 기능을 일시적으로 줄이는 전략!
        - 평소에는 모든 기능을 다 제공하다가 갑자기 서버에 트래픽이 몰릴 거 같은 상황이 발생하면 중요한 기능만 제공하는 등 이러한 방식
        - 일본 nhk web이 이를 잘 사용(경량화 페이지)
        
        ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%206.png)
        
        ![Untitled](%E1%84%83%E1%85%A2%E1%84%80%E1%85%B2%E1%84%86%E1%85%A9%20%E1%84%90%E1%85%B3%E1%84%85%E1%85%A2%E1%84%91%E1%85%B5%E1%86%A8%20(1)%207df2d16eb90b46d7aed95fe5dd885748/Untitled%207.png)
        
        [전국민이 놀란 새벽의 경계경보](https://youtu.be/xEu1bZqudE8?t=1070)